program threadstatic.dpr;
{$APPTYPE CONSOLE}

//
// This example demonstrates how to use native .NET methods to create a thread on 
// a class with a static class method.
//
// Written by: Rick Ross (http://www.rick-ross.com/)
//

uses
   System.Threading;

type
  ThreadMe = class
  public
    class procedure MyThreadMethod; static;
  end;

class procedure ThreadMe.MyThreadMethod;
var
  stop : integer;
  curNum : integer;
  rnd    : System.Random;

begin
  rnd    := System.Random.Create;
  curNum := rnd.Next(1000);
  stop := curNum + 10;
  while curNum < stop do
  begin
    writeln('Thread ', System.Threading.Thread.CurrentThread.Name ,
            ' current value is ',curNum);
    inc(curNum);
    Thread.Sleep( 3 );
  end; 
end;

var
  thrd1 : Thread;
  thrd2 : Thread;

begin
  writeln('Staring threading instance example...');

  thrd1 := Thread.Create( @ThreadMe.MyThreadMethod );
  thrd1.Name := 'one';

  thrd2 := Thread.create( @ThreadMe.MyThreadMethod );
  thrd2.Name := 'two';

  thrd1.Start();
  thrd2.Start();

  readln;

  writeln('Done');
end.

